import os

from .utils import DatasetBase
from .oxford_pets import OxfordPets

template = ['a photo of {}, a type of food.']
# template = ['a bad photo of a {}, a type of food.',
#     'a photo of many {}, a type of food.',
#     'a sculpture of a {}, a type of food.',
#     'a photo of the hard to see {}, a type of food.',
#     'a low resolution photo of the {}, a type of food.',
#     'a rendering of a {}, a type of food.',
#     'graffiti of a {}, a type of food.',
#     'a bad photo of the {}, a type of food.',
#     'a cropped photo of the {}, a type of food.',
#     'a tattoo of a {}, a type of food.',
#     'the embroidered {}, a type of food.',
#     'a photo of a hard to see {}, a type of food.',
#     'a bright photo of a {}, a type of food.',
#     'a photo of a clean {}, a type of food.',
#     'a photo of a dirty {}, a type of food.',
#     'a dark photo of the {}, a type of food.',
#     'a drawing of a {}, a type of food.',
#     'a photo of my {}, a type of food.',
#     'the plastic {}, a type of food.',
#     'a photo of the cool {}, a type of food.',
#     'a close-up photo of a {}, a type of food.',
#     'a black and white photo of the {}, a type of food.',
#     'a painting of the {}, a type of food.',
#     'a painting of a {}, a type of food.',
#     'a pixelated photo of the {}, a type of food.',
#     'a sculpture of the {}, a type of food.',
#     'a bright photo of the {}, a type of food.',
#     'a cropped photo of a {}, a type of food.',
#     'a plastic {}, a type of food.',
#     'a photo of the dirty {}, a type of food.',
#     'a jpeg corrupted photo of a {}, a type of food.',
#     'a blurry photo of the {}, a type of food.',
#     'a photo of the {}, a type of food.',
#     'a good photo of the {}, a type of food.',
#     'a rendering of the {}, a type of food.',
#     'a {} in a video game, a type of food.',
#     'a photo of one {}, a type of food.',
#     'a doodle of a {}, a type of food.',
#     'a close-up photo of the {}, a type of food.',
#     'a photo of a {}, a type of food.',
#     'the origami {}, a type of food.',
#     'the {} in a video game., a type of food',
#     'a sketch of a {}, a type of food.',
#     'a doodle of the {}, a type of food.',
#     'a origami {}, a type of food.',
#     'a low resolution photo of a {}, a type of food.',
#     'the toy {}, a type of food.',
#     'a rendition of the {}, a type of food.',
#     'a photo of the clean {}, a type of food.',
#     'a photo of a large {}, a type of food.',
#     'a rendition of a {}, a type of food.',
#     'a photo of a nice {}, a type of food.',
#     'a photo of a weird {}, a type of food.',
#     'a blurry photo of a {}, a type of food.',
#     'a cartoon {}, a type of food.',
#     'art of a {}, a type of food.',
#     'a sketch of the {}, a type of food.',
#     'a embroidered {}, a type of food.',
#     'a pixelated photo of a {}, a type of food.',
#     'itap of the {}, a type of food.',
#     'a jpeg corrupted photo of the {}, a type of food.',
#     'a good photo of a {}, a type of food.',
#     'a plushie {}, a type of food.',
#     'a photo of the nice {}, a type of food.',
#     'a photo of the small {}, a type of food.',
#     'a photo of the weird {}, a type of food.',
#     'the cartoon {}, a type of food.',
#     'art of the {}, a type of food.',
#     'a drawing of the {}, a type of food.',
#     'a photo of the large {}, a type of food.',
#     'a black and white photo of a {}, a type of food.',
#     'the plushie {}, a type of food.',
#     'a dark photo of a {}, a type of food.',
#     'itap of a {}, a type of food.',
#     'graffiti of the {}, a type of food.',
#     'a toy {}, a type of food.',
#     'itap of my {}, a type of food.',
#     'a photo of a cool {}, a type of food.',
#     'a photo of a small {}, a type of food.',
#     'a tattoo of the {}, a type of food.']
class Food101(DatasetBase):

    dataset_dir = 'food-101'

    def __init__(self, root):
        self.dataset_dir = os.path.join(root, self.dataset_dir)
        self.image_dir = os.path.join(self.dataset_dir, 'images')
        self.split_path = os.path.join(self.dataset_dir, 'split_zhou_Food101.json')
        
        self.template = template

        test = OxfordPets.read_split(self.split_path, self.image_dir)

        super().__init__(test=test)